/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Vector;
import jclass.bwt.BWTUtil;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCComponent;
import jclass.bwt.JCHeader;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCMultiColumnData;
import jclass.bwt.JCMultiColumnInterface;
import jclass.bwt.JCMultiColumnWindow;
import jclass.bwt.JCOutlinerEvent;
import jclass.bwt.JCOutlinerFolderNode;
import jclass.bwt.JCOutlinerInterface;
import jclass.bwt.JCOutlinerListener;
import jclass.bwt.JCOutlinerNode;
import jclass.bwt.JCOutlinerNodeStyle;
import jclass.bwt.JCScrollableInterface;
import jclass.bwt.OutlinerConverter;
import jclass.bwt.OutlinerMultiColumnData;
import jclass.util.JCImageCreator;
import jclass.util.JCSortInterface;
import jclass.util.JCVector;
import jclass.util.JCqsort;

public class JCOutlinerComponent
extends JCComponent
implements JCOutlinerInterface,
JCMultiColumnInterface,
JCSortInterface,
JCScrollableInterface {
    public static final int FOLDER_CLOSED = 1;
    public static final int FOLDER_OPEN_NONE = 2;
    public static final int FOLDER_OPEN_FOLDERS = 3;
    public static final int FOLDER_OPEN_ITEMS = 4;
    public static final int FOLDER_OPEN_ALL = 5;
    public static final int DRAGDROP_NONE = 0;
    public static final int DRAGDROP_TARGET = 1;
    public static final int DRAGDROP_SOURCE = 2;
    public static final int DRAGDROP_ALL = 4;
    JCOutlinerNode root;
    boolean auto_select = true;
    int visible_rows;
    int num_rows;
    JCOutlinerNode selected_node;
    JCOutlinerNode focus_node;
    boolean batched = false;
    boolean needs_recalc = false;
    boolean needs_repaint = false;
    Event last_event;
    int node_height;
    int node_indent = 15;
    int horiz_origin;
    int vert_origin;
    int spacing;
    int[] state_list = new int[]{1, 5};
    boolean root_visible = true;
    JCVector visible_nodes = new JCVector();
    int bottom_y;
    protected OutlinerMultiColumnData data = new OutlinerMultiColumnData(this);
    protected transient JCMultiColumnWindow scrolled_window;
    protected JCVector node_list = new JCVector();
    boolean root_shortcut;
    int sort_column;
    int sort_direction;
    JCSortInterface sort_method;
    int pref_height_internal;
    int pref_width_internal;
    protected JCOutlinerNodeStyle[] style_list;
    protected JCOutlinerNodeStyle default_style;
    protected transient Image shortcut_open_icon;
    protected transient Image shortcut_close_icon;
    protected static final int SHORTCUT_SIZE = 9;
    protected static final int BEGIN = 0;
    protected static final int END = 1;
    protected int full_node_height;
    Rectangle draw_rect = new Rectangle();
    protected JCVector itemListeners = new JCVector(0);
    protected JCVector actionListeners = new JCVector(0);
    private static final String base = "outliner";
    private static int nameCounter;
    static final String[] item_icon;
    static final String[] folder_open_icon;
    static final String[] folder_closed_icon;
    static final String[] shortcut_open_icon_string;
    static final String[] shortcut_close_icon_string;
    Image buffer_image;
    Graphics buffer_image_gc;
    int drag_drop = 0;
    static JCOutlinerNode drag_node;
    static JCOutlinerNode drop_node;

    public JCOutlinerComponent() {
        this(null, null, null);
    }

    public JCOutlinerComponent(JCOutlinerNode jCOutlinerNode) {
        this(jCOutlinerNode, null, null);
    }

    public JCOutlinerComponent(JCOutlinerNode jCOutlinerNode, Applet applet, String string) {
        super(applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        this.root = jCOutlinerNode;
        this.insets = new Insets(5, 5, 5, 5);
        this.style_list = new JCOutlinerNodeStyle[1];
        this.default_style = new JCOutlinerNodeStyle();
        JCImageCreator jCImageCreator = new JCImageCreator(this, 16, 16);
        jCImageCreator.setColor('X', Color.white);
        jCImageCreator.setColor('.', Color.black);
        jCImageCreator.setColor('o', Color.white);
        this.default_style.item = this.default_style.item_selected = jCImageCreator.create(item_icon);
        jCImageCreator.setColor('X', Color.yellow);
        this.default_style.folder_closed_selected = this.default_style.folder_closed = jCImageCreator.create(folder_closed_icon);
        jCImageCreator.setColor('o', Color.lightGray);
        this.default_style.folder_open_selected = this.default_style.folder_open = jCImageCreator.create(folder_open_icon);
        this.style_list[0] = this.default_style;
        if (this.getClass().getName().equals("jclass.bwt.JCOutlinerComponent")) {
            this.getParameters(applet);
        }
    }

    protected void getParameters() {
        super.getParameters();
        OutlinerConverter.getParams(this);
    }

    public synchronized void setFont(Font font) {
        super.setFont(font);
        if (this.getPeer() == null) {
            return;
        }
        this.calcColumnWidths();
        this.setNodeHeight(0);
    }

    void calcColumnWidths() {
        if (this.batched) {
            this.needs_recalc = true;
            return;
        }
        this.data.calcColumnWidths();
    }

    protected void processRootNode() {
        if (this.batched) {
            this.needs_recalc = true;
            return;
        }
        this.num_rows = this.countRows(this.root);
        this.node_list = new JCVector(this.countAllNodes(this.root, null));
        this.countAllNodes(this.root, this.node_list);
        if (this.focus_node != null && this.node_list.contains(this.focus_node)) {
            return;
        }
        JCOutlinerNode jCOutlinerNode = null;
        int n = 0;
        int n2 = this.node_list.size();
        while (n < n2) {
            jCOutlinerNode = (JCOutlinerNode)this.node_list.elementAt(n);
            if (this.shouldBeDrawn(jCOutlinerNode)) break;
            ++n;
        }
        this.setFocusNode(jCOutlinerNode, null);
    }

    JCHeader getHeader() {
        if (this.scrolled_window != null && this.scrolled_window instanceof JCMultiColumnWindow) {
            return this.scrolled_window.getHeader();
        }
        return null;
    }

    JCMultiColumnWindow getWindow() {
        if (this.scrolled_window != null && this.scrolled_window instanceof JCMultiColumnWindow) {
            return this.scrolled_window;
        }
        return null;
    }

    public synchronized void setColumnLabels(JCVector jCVector) {
        if (this.getWindow() != null) {
            this.getWindow().setColumnLabels(jCVector);
        }
    }

    public synchronized void setColumnButtons(JCVector jCVector) {
        if (this.getWindow() != null) {
            this.getWindow().setColumnButtons(jCVector);
        }
    }

    public synchronized void folderChanged(JCOutlinerNode jCOutlinerNode) {
        if (this.getPeer() == null) {
            return;
        }
        if (this.batched) {
            this.needs_recalc = true;
            return;
        }
        if (jCOutlinerNode != null) {
            this.processRootNode();
        }
        this.calcColumnWidths();
        if (this.getHeader() != null) {
            this.getHeader().recalc();
        }
        this.updateParent();
        this.repaint();
    }

    public JCOutlinerNode getRootNode() {
        return this.root;
    }

    public synchronized void setRootNode(JCOutlinerNode jCOutlinerNode) {
        this.root = jCOutlinerNode;
        this.folderChanged(jCOutlinerNode);
    }

    public String[] getTree() {
        return OutlinerConverter.getTree(this);
    }

    public synchronized void setTree(String[] stringArray) {
        this.setRootNode(OutlinerConverter.createTree(this, stringArray));
    }

    public boolean getRootVisible() {
        return this.root_visible;
    }

    public synchronized void setRootVisible(boolean bl) {
        this.root_visible = bl;
        this.repaint();
    }

    public boolean getBatched() {
        return this.batched;
    }

    public synchronized void setBatched(boolean bl) {
        if (this.batched == bl) {
            return;
        }
        this.batched = bl;
        if (this.batched) {
            return;
        }
        if (this.needs_recalc) {
            this.folderChanged(null);
        }
        if (this.needs_recalc || this.needs_repaint) {
            this.repaint();
        }
        this.needs_repaint = false;
        this.needs_recalc = false;
    }

    public int getNodeHeight() {
        return this.node_height;
    }

    public synchronized void setNodeHeight(int n) {
        this.node_height = n;
        this.updateParent();
        this.repaint();
    }

    public int getNumNodes() {
        return this.num_rows;
    }

    public boolean getAutoSelect() {
        return this.auto_select;
    }

    public synchronized void setAutoSelect(boolean bl) {
        this.auto_select = bl;
        this.repaint();
    }

    public int getNodeIndent() {
        return this.node_indent;
    }

    public synchronized void setNodeIndent(int n) {
        this.node_indent = n;
        this.repaint();
    }

    public int[] getStateList() {
        return this.state_list;
    }

    private void mapStateInNode(JCOutlinerNode jCOutlinerNode) {
        if (!(jCOutlinerNode instanceof JCOutlinerFolderNode)) {
            return;
        }
        JCOutlinerFolderNode jCOutlinerFolderNode = (JCOutlinerFolderNode)jCOutlinerNode;
        if (jCOutlinerFolderNode.children == null) {
            return;
        }
        boolean bl = false;
        int n = 0;
        while (n < jCOutlinerFolderNode.children.size()) {
            JCOutlinerNode jCOutlinerNode2 = (JCOutlinerNode)jCOutlinerFolderNode.children.elementAt(n);
            if (jCOutlinerNode2 instanceof JCOutlinerFolderNode) {
                this.mapStateInNode(jCOutlinerNode2);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.state_list.length) {
            if (jCOutlinerFolderNode.state == this.state_list[n2]) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            int n3 = 5;
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.state_list.length) {
                int n6 = Math.abs(jCOutlinerFolderNode.state - this.state_list[n5]);
                if (n6 < n3) {
                    n3 = n6;
                    n4 = n5;
                }
                ++n5;
            }
            jCOutlinerFolderNode.state = this.state_list[n4];
        }
    }

    public synchronized void setStateList(int[] nArray) {
        this.state_list = nArray;
        this.mapStateInNode(this.root);
        this.folderChanged(this.root);
    }

    public JCOutlinerNodeStyle[] getStyleList() {
        return this.style_list;
    }

    public synchronized void setStyleList(JCOutlinerNodeStyle[] jCOutlinerNodeStyleArray) {
        this.style_list = jCOutlinerNodeStyleArray;
        this.node_height = 0;
        this.updateParent();
        this.repaint();
    }

    public synchronized void setForeground(Color color) {
        super.setForeground(color);
        this.createShortcutIcons();
    }

    public synchronized void setBackground(Color color) {
        super.setBackground(color);
        this.createShortcutIcons();
    }

    public JCOutlinerNodeStyle getDefaultNodeStyle() {
        return this.default_style;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public synchronized void setSpacing(int n) {
        this.spacing = n;
        this.updateParent();
        this.repaint();
    }

    public int getVisibleRows() {
        return this.visible_rows;
    }

    public synchronized void setVisibleRows(int n) {
        this.visible_rows = n;
        this.updateParent();
        this.repaint();
    }

    public synchronized int getSelectedIndex() {
        if (this.selected_node != null) {
            return this.selected_node.row;
        }
        return -999;
    }

    public synchronized int[] getSelectedIndexes() {
        if (this.selected_node != null) {
            int[] nArray = new int[]{this.selected_node.row};
            return nArray;
        }
        return null;
    }

    public synchronized Object[] getSelectedObjects() {
        if (this.selected_node != null) {
            Object[] objectArray = new Object[]{this.selected_node.getLabelString()};
            return objectArray;
        }
        return null;
    }

    public synchronized JCOutlinerNode getSelectedNode() {
        return this.selected_node;
    }

    public synchronized void selectNode(JCOutlinerNode jCOutlinerNode, Event event) {
        JCItemListener jCItemListener;
        int n;
        Component component;
        if (jCOutlinerNode == this.selected_node) {
            return;
        }
        JCOutlinerEvent jCOutlinerEvent = null;
        Component component2 = component = this.scrolled_window != null ? this.scrolled_window : this;
        if (this.itemListeners.size() > 0) {
            jCOutlinerEvent = new JCOutlinerEvent((JCOutlinerInterface)((Object)component), this.selected_node, false);
        }
        if (this.selected_node != null) {
            n = 0;
            while (n < this.itemListeners.size()) {
                jCItemListener = (JCItemListener)this.itemListeners.elementAt(n);
                if (jCItemListener instanceof JCOutlinerListener) {
                    jCItemListener.itemStateChanged(jCOutlinerEvent);
                    ((JCOutlinerListener)jCItemListener).outlinerNodeSelectBegin(jCOutlinerEvent);
                    if (!jCOutlinerEvent.doit) {
                        return;
                    }
                }
                ++n;
            }
            this.selected_node.selected = false;
            this.drawNode(this.selected_node, true);
        }
        this.selected_node = jCOutlinerNode;
        if (jCOutlinerNode != null) {
            jCOutlinerNode.selected = true;
            this.drawNode(this.selected_node, false);
        }
        if (this.itemListeners.size() > 0) {
            jCOutlinerEvent = new JCOutlinerEvent((JCOutlinerInterface)((Object)component), jCOutlinerNode, true);
        }
        n = 0;
        while (n < this.itemListeners.size()) {
            jCItemListener = (JCItemListener)this.itemListeners.elementAt(n);
            jCItemListener.itemStateChanged(jCOutlinerEvent);
            if (jCItemListener instanceof JCOutlinerListener) {
                ((JCOutlinerListener)jCItemListener).outlinerNodeSelectEnd(jCOutlinerEvent);
            }
            ++n;
        }
        if (this.auto_select) {
            this.focus_node = jCOutlinerNode;
        }
    }

    private void selectNode(JCOutlinerNode jCOutlinerNode) {
        if (jCOutlinerNode == this.selected_node) {
            return;
        }
        if (this.selected_node != null) {
            this.selected_node.selected = false;
            this.drawNode(this.selected_node, true);
        }
        this.selected_node = jCOutlinerNode;
        if (jCOutlinerNode != null) {
            jCOutlinerNode.selected = true;
            this.drawNode(this.selected_node, false);
        }
        if (this.auto_select) {
            this.focus_node = jCOutlinerNode;
        }
    }

    public JCOutlinerNode getFocusNode() {
        return this.focus_node;
    }

    public synchronized void setFocusNode(JCOutlinerNode jCOutlinerNode, Event event) {
        if (jCOutlinerNode == this.focus_node || jCOutlinerNode == null) {
            return;
        }
        JCOutlinerNode jCOutlinerNode2 = this.focus_node;
        this.focus_node = jCOutlinerNode;
        this.drawNode(jCOutlinerNode2, true);
        this.makeNodeVisible(this.focus_node);
        this.drawNode(this.focus_node, false);
        if (this.auto_select) {
            this.selectNode(jCOutlinerNode, event);
        }
    }

    public JCVector getVisibleNodes() {
        return this.visible_nodes;
    }

    public JCOutlinerNode findNode(char c) {
        c = Character.toUpperCase(c);
        JCOutlinerNode jCOutlinerNode = this.root;
        while (jCOutlinerNode != null) {
            if (BWTUtil.startsWith(jCOutlinerNode.label, c)) {
                return jCOutlinerNode;
            }
            jCOutlinerNode = this.getNextVisibleNode(jCOutlinerNode);
        }
        return null;
    }

    public int calculateNodeHeight(JCOutlinerNode jCOutlinerNode) {
        return this.calculateStyleHeight(jCOutlinerNode.style);
    }

    protected int calculateStyleHeight(JCOutlinerNodeStyle jCOutlinerNodeStyle) {
        if (jCOutlinerNodeStyle == null) {
            return 0;
        }
        int n = 0;
        if (jCOutlinerNodeStyle.font != null) {
            n = this.getToolkit().getFontMetrics(jCOutlinerNodeStyle.font).getHeight();
        }
        if (jCOutlinerNodeStyle.item != null) {
            n = Math.max(n, jCOutlinerNodeStyle.item.getHeight(null));
        }
        if (jCOutlinerNodeStyle.item_selected != null) {
            n = Math.max(n, jCOutlinerNodeStyle.item_selected.getHeight(null));
        }
        if (jCOutlinerNodeStyle.folder_closed != null) {
            n = Math.max(n, jCOutlinerNodeStyle.folder_closed.getHeight(null));
        }
        if (jCOutlinerNodeStyle.folder_closed_selected != null) {
            n = Math.max(n, jCOutlinerNodeStyle.folder_closed_selected.getHeight(null));
        }
        if (jCOutlinerNodeStyle.folder_open != null) {
            n = Math.max(n, jCOutlinerNodeStyle.folder_open.getHeight(null));
        }
        if (jCOutlinerNodeStyle.folder_open_selected != null) {
            n = Math.max(n, jCOutlinerNodeStyle.folder_open_selected.getHeight(null));
        }
        return n;
    }

    protected int preferredHeight() {
        int n;
        this.default_style.font = this.getFont();
        if (this.node_height == 0) {
            n = 0;
            while (n < this.style_list.length) {
                this.node_height = Math.max(this.node_height, this.calculateStyleHeight(this.style_list[n]));
                ++n;
            }
        }
        this.full_node_height = this.node_height + 2 * this.highlight + this.spacing;
        n = this.visible_rows > 0 ? this.visible_rows : this.num_rows;
        return n * this.full_node_height + 2 * (this.shadow + this.highlight) + this.insets.top + this.insets.bottom;
    }

    protected int preferredWidth() {
        if (this.pref_width_internal == 0) {
            this.calcColumnWidths();
        }
        this.pref_width_internal = this.data.preferredWidth();
        return this.pref_width_internal;
    }

    public synchronized void repaint() {
        if (this.batched) {
            this.needs_repaint = true;
            return;
        }
        super.repaint();
    }

    void createShortcutIcons() {
        JCImageCreator jCImageCreator = new JCImageCreator(this, 9, 9);
        Color color = this.getForeground();
        Color color2 = this.getBackground();
        jCImageCreator.setColor('.', color != null ? color : Color.black);
        jCImageCreator.setColor(' ', color2 != null ? color2 : Color.white);
        this.shortcut_open_icon = jCImageCreator.create(shortcut_open_icon_string);
        this.shortcut_close_icon = jCImageCreator.create(shortcut_close_icon_string);
    }

    public void addNotify() {
        super.addNotify();
        this.createShortcutIcons();
        this.processRootNode();
        JCHeader jCHeader = this.getHeader();
        if (this.getNumColumns() > 1 || jCHeader != null && this.getNumColumns() < jCHeader.getLabels().length) {
            this.calcColumnWidths();
            this.pref_width_internal = this.data.preferredWidth();
        }
    }

    public synchronized void setDoubleBuffer(boolean bl) {
    }

    public void invalidate() {
        super.invalidate();
        this.buffer_image = null;
        this.buffer_image_gc = null;
    }

    public Image getDoubleBufferImage() {
        return this.buffer_image;
    }

    public synchronized Graphics getDoubleBufferGraphics() {
        Image image = this.buffer_image;
        this.buffer_image = BWTUtil.createImage(this, this.buffer_image, this.size().width, this.size().height);
        if (this.buffer_image != image || this.buffer_image_gc == null) {
            this.buffer_image_gc = this.buffer_image.getGraphics();
        }
        return this.buffer_image_gc;
    }

    void copyArea(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw_gc = graphics;
        graphics = this.getDoubleBufferGraphics();
        this.buffer_image = this.getDoubleBufferImage();
        this.getDrawingArea(this.draw_rect);
        graphics.setClip(this.draw_rect);
        graphics.copyArea(n, n2, n3, n4, n5, n6);
        graphics.setClip(n + n5, n2 + n6, n3, n4);
        this.draw_gc.drawImage(this.buffer_image, 0, 0, null);
    }

    protected void paintComponent(Graphics graphics) {
        this.visible_nodes.removeAllElements();
        this.root_shortcut = this.getStyle((JCOutlinerNode)this.root).shortcut;
        this.getDrawingArea(this.draw_rect);
        this.bottom_y = this.draw_rect.y + this.draw_rect.height;
        this.drawNode(this.root, this.root_visible ? 0 : -1, this.root_visible ? 0 : -1, graphics);
    }

    public boolean setNodeState(JCOutlinerNode jCOutlinerNode, int n, boolean bl) {
        if (jCOutlinerNode instanceof JCOutlinerFolderNode) {
            Serializable serializable;
            OutlinerConverter.checkState(n);
            if (bl) {
                serializable = this.postActionEvent(this.last_event, 0, jCOutlinerNode, n);
                if (serializable != null) {
                    if (!((JCOutlinerEvent)serializable).doit) {
                        return false;
                    }
                    n = ((JCOutlinerEvent)serializable).new_state;
                }
                if (!this.shouldBeDrawn(jCOutlinerNode) || !this.checkState(n)) {
                    return false;
                }
            }
            int n2 = (serializable = (JCOutlinerFolderNode)jCOutlinerNode) == this.root ? this.num_rows : this.countRows((JCOutlinerNode)serializable);
            serializable.state = n;
            this.num_rows += this.countRows((JCOutlinerNode)serializable) - n2;
            this.folderChanged(null);
            this.repaint();
        }
        if (bl) {
            this.postActionEvent(this.last_event, 1, jCOutlinerNode, n);
        }
        return true;
    }

    public boolean makeNodeVisible(JCOutlinerNode jCOutlinerNode) {
        if (!this.shouldBeDrawn(jCOutlinerNode)) {
            return false;
        }
        if (this.visible_nodes.contains(jCOutlinerNode)) {
            return true;
        }
        int n = this.vert_origin;
        JCOutlinerNode jCOutlinerNode2 = (JCOutlinerNode)this.visible_nodes.getFirst();
        JCOutlinerNode jCOutlinerNode3 = (JCOutlinerNode)this.visible_nodes.getLast();
        if (jCOutlinerNode2 == null || jCOutlinerNode2 != null && jCOutlinerNode.sequence < jCOutlinerNode2.sequence) {
            int n2 = this.countPreviousRows(jCOutlinerNode);
            n = n2 * this.full_node_height;
        } else if (jCOutlinerNode3 != null && jCOutlinerNode.sequence > jCOutlinerNode3.sequence) {
            int n3 = this.countRows(jCOutlinerNode3, jCOutlinerNode);
            n = this.vert_origin + n3 * this.full_node_height;
        }
        if (this.scrolled_window != null) {
            this.scrolled_window.scrollVertical(n);
        }
        return true;
    }

    protected boolean checkState(int n) {
        int n2 = 0;
        while (n2 < this.state_list.length) {
            if (n == this.state_list[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected int getNextState(JCOutlinerNode jCOutlinerNode) {
        if (!(jCOutlinerNode instanceof JCOutlinerFolderNode)) {
            return -999;
        }
        int n = 0;
        while (n < this.state_list.length) {
            if (jCOutlinerNode.getState() == this.state_list[n]) break;
            ++n;
        }
        if (++n >= this.state_list.length) {
            n = 0;
        }
        return this.state_list[n];
    }

    public JCOutlinerNode getNextNode(JCOutlinerNode jCOutlinerNode) {
        if (jCOutlinerNode == null || jCOutlinerNode.sequence >= this.node_list.size() - 1) {
            return null;
        }
        return (JCOutlinerNode)this.node_list.elementAt(jCOutlinerNode.sequence + 1);
    }

    public JCOutlinerNode getNextVisibleNode(JCOutlinerNode jCOutlinerNode) {
        if (jCOutlinerNode == null) {
            return null;
        }
        int n = jCOutlinerNode.sequence + 1;
        int n2 = this.node_list.size();
        while (n < n2) {
            jCOutlinerNode = (JCOutlinerNode)this.node_list.elementAt(n);
            if (this.shouldBeDrawn(jCOutlinerNode)) {
                return jCOutlinerNode;
            }
            ++n;
        }
        return null;
    }

    public JCOutlinerNode getPreviousNode(JCOutlinerNode jCOutlinerNode) {
        if (jCOutlinerNode == null || jCOutlinerNode.sequence == 0) {
            return null;
        }
        return (JCOutlinerNode)this.node_list.elementAt(jCOutlinerNode.sequence - 1);
    }

    public JCOutlinerNode getPreviousVisibleNode(JCOutlinerNode jCOutlinerNode) {
        if (jCOutlinerNode == null) {
            return null;
        }
        int n = jCOutlinerNode.sequence - 1;
        while (n >= 0) {
            jCOutlinerNode = (JCOutlinerNode)this.node_list.elementAt(n);
            if (this.shouldBeDrawn(jCOutlinerNode)) {
                return jCOutlinerNode;
            }
            --n;
        }
        return null;
    }

    protected boolean nextFocus(Event event) {
        this.setFocusNode(this.getNextVisibleNode(this.focus_node), event);
        return true;
    }

    protected boolean previousFocus(Event event) {
        this.setFocusNode(this.getPreviousVisibleNode(this.focus_node), event);
        return true;
    }

    public void addItemListener(JCItemListener jCItemListener) {
        this.itemListeners.add(jCItemListener);
    }

    public void removeItemListener(JCItemListener jCItemListener) {
        this.itemListeners.removeElement(jCItemListener);
    }

    public void addActionListener(JCActionListener jCActionListener) {
        this.actionListeners.add(jCActionListener);
    }

    public void removeActionListener(JCActionListener jCActionListener) {
        this.actionListeners.removeElement(jCActionListener);
    }

    protected JCOutlinerEvent postActionEvent(Event event, int n, JCOutlinerNode jCOutlinerNode, int n2) {
        Component component;
        JCOutlinerEvent jCOutlinerEvent = null;
        Component component2 = component = this.scrolled_window != null ? this.scrolled_window : this;
        if (jCOutlinerNode instanceof JCOutlinerFolderNode && this.itemListeners.size() > 0) {
            jCOutlinerEvent = new JCOutlinerEvent((JCOutlinerInterface)((Object)component), jCOutlinerNode, n2);
            int n3 = 0;
            while (n3 < this.itemListeners.size()) {
                JCItemListener jCItemListener = (JCItemListener)this.itemListeners.elementAt(n3);
                if (n == 1) {
                    jCItemListener.itemStateChanged(jCOutlinerEvent);
                }
                if (jCItemListener instanceof JCOutlinerListener) {
                    JCOutlinerListener jCOutlinerListener = (JCOutlinerListener)jCItemListener;
                    if (n == 0) {
                        jCOutlinerListener.outlinerFolderStateChangeBegin(jCOutlinerEvent);
                    } else {
                        jCOutlinerListener.outlinerFolderStateChangeEnd(jCOutlinerEvent);
                    }
                }
                ++n3;
            }
        }
        if (n == 1 && !(jCOutlinerNode instanceof JCOutlinerFolderNode)) {
            JCActionEvent jCActionEvent = new JCActionEvent(component, 1001, null);
            int n4 = 0;
            while (n4 < this.actionListeners.size()) {
                ((JCActionListener)this.actionListeners.elementAt(n4)).actionPerformed(jCActionEvent);
                ++n4;
            }
        }
        return jCOutlinerEvent;
    }

    protected boolean doubleClickAction(JCOutlinerNode jCOutlinerNode, Event event) {
        return this.setNodeState(jCOutlinerNode, this.getNextState(jCOutlinerNode), true);
    }

    public boolean keyDown(Event event, int n) {
        if (event.key == 1005) {
            return this.nextFocus(event);
        }
        if (event.key == 1004) {
            return this.previousFocus(event);
        }
        if (event.key == 10) {
            return this.doubleClickAction(this.focus_node, event);
        }
        if (event.key == 32) {
            this.makeNodeVisible(this.focus_node);
            this.selectNode(this.focus_node, event);
            return true;
        }
        JCOutlinerNode jCOutlinerNode = this.findNode((char)n);
        if (jCOutlinerNode != null) {
            this.makeNodeVisible(jCOutlinerNode);
            this.setFocusNode(jCOutlinerNode, event);
            this.selectNode(jCOutlinerNode, event);
            return true;
        }
        return super.keyDown(event, n);
    }

    public JCOutlinerNode eventToNode(Event event) {
        return this.eventToNode(event, false);
    }

    public JCOutlinerNode eventToNode(Event event, boolean bl) {
        if (this.full_node_height == 0) {
            return null;
        }
        JCOutlinerNode jCOutlinerNode = this.findNode(this.root, (event.y - this.shadow - this.insets.top + this.vert_origin) / this.full_node_height);
        if (jCOutlinerNode != null && bl) {
            this.getBounds(jCOutlinerNode, this.draw_rect);
            if (!this.draw_rect.inside(event.x, event.y)) {
                jCOutlinerNode = null;
            }
        }
        return jCOutlinerNode;
    }

    public boolean eventInShortcut(Event event, JCOutlinerNode jCOutlinerNode) {
        if (jCOutlinerNode instanceof JCOutlinerFolderNode) {
            JCOutlinerFolderNode jCOutlinerFolderNode = (JCOutlinerFolderNode)jCOutlinerNode;
            if (jCOutlinerFolderNode.shortcut_x != -999) {
                this.draw_rect.reshape(jCOutlinerFolderNode.shortcut_x - 4, jCOutlinerFolderNode.shortcut_y - 4, 9, 9);
                return this.draw_rect.inside(event.x, event.y);
            }
        }
        return false;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        super.mouseDown(event, n, n2);
        this.last_event = event;
        JCOutlinerNode jCOutlinerNode = this.eventToNode(event);
        if (jCOutlinerNode == null) {
            return true;
        }
        if (this.eventInShortcut(event, jCOutlinerNode)) {
            return this.doubleClickAction(jCOutlinerNode, event);
        }
        this.getBounds(jCOutlinerNode, this.draw_rect);
        if (!this.draw_rect.inside(n, n2)) {
            return false;
        }
        boolean bl = false;
        if (event.clickCount == 2 && jCOutlinerNode.selected) {
            bl = true;
        }
        this.setFocusNode(jCOutlinerNode, event);
        if (!bl && jCOutlinerNode.selected) {
            return true;
        }
        if (!this.auto_select) {
            this.selectNode(jCOutlinerNode, event);
        }
        boolean bl2 = true;
        if (bl) {
            bl2 = this.doubleClickAction(jCOutlinerNode, event);
        }
        this.last_event = null;
        return bl2;
    }

    public int getDragAndDropPolicy() {
        return this.drag_drop;
    }

    public void setDragAndDropPolicy(int n) {
        this.drag_drop = n;
        if (n != 0) {
            this.enable11Events(32L);
        }
    }

    protected boolean isDropTarget(JCOutlinerNode jCOutlinerNode, JCOutlinerNode jCOutlinerNode2) {
        if (jCOutlinerNode == null || jCOutlinerNode2 == null || jCOutlinerNode == jCOutlinerNode2) {
            return false;
        }
        JCOutlinerFolderNode jCOutlinerFolderNode = jCOutlinerNode2.parent;
        while (jCOutlinerFolderNode != null && jCOutlinerFolderNode != jCOutlinerNode) {
            jCOutlinerFolderNode = jCOutlinerFolderNode.parent;
        }
        return jCOutlinerFolderNode == null;
    }

    Component locateComponent(Container container, int n, int n2) {
        if (!container.inside(n, n2)) {
            return null;
        }
        int n3 = container.countComponents() - 1;
        while (n3 >= 0) {
            Component component = container.getComponents()[n3];
            if (component.isVisible() && component.isEnabled() && component.inside(n - component.location().x, n2 - component.location().y)) {
                if (component instanceof Container) {
                    return this.locateComponent((Container)component, n - component.location().x, n2 - component.location().y);
                }
                return component;
            }
            --n3;
        }
        return null;
    }

    boolean processDropOver(Event event) {
        Point point = BWTUtil.translateToParent(this.getFrame(), this, event.x, event.y);
        Component component = this.locateComponent(this.getFrame(), point.x, point.y);
        if (component == this || !(component instanceof JCOutlinerComponent)) {
            return false;
        }
        point = BWTUtil.translateFromParent(this.getFrame(), component, point.x, point.y);
        event.x = point.x;
        event.y = point.y;
        return ((JCOutlinerComponent)component).dropOver(event);
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.inside(n, n2) && this.dropOver(event)) {
            return true;
        }
        return this.processDropOver(event);
    }

    public boolean dropOver(Event event) {
        if (this.drag_drop == 0) {
            return false;
        }
        JCOutlinerNode jCOutlinerNode = this.eventToNode(event, true);
        if (drag_node == null) {
            drag_node = jCOutlinerNode;
        } else if (drag_node != this.root && drop_node == null) {
            drop_node = this.isDropTarget(drag_node, jCOutlinerNode) ? jCOutlinerNode : null;
        } else if (drop_node != null && drop_node != jCOutlinerNode) {
            JCOutlinerComponent.drop_node.selected = false;
            this.drawNode(drop_node, true);
            JCOutlinerNode jCOutlinerNode2 = drop_node = this.isDropTarget(drag_node, jCOutlinerNode) ? jCOutlinerNode : null;
        }
        if (drag_node != this.root) {
            int n;
            int n2 = n = drop_node != null ? 12 : 3;
            if (drop_node == null && drag_node != this.root) {
                n = 12;
            }
            this.setCursor(n);
        }
        if (drag_node != this.root && drop_node != null) {
            this.selectNode(drop_node);
            this.makeNodeVisible(drop_node);
        }
        return drop_node != null;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.inside(n, n2) && this.drop(event)) {
            return true;
        }
        return this.processDrop(event);
    }

    boolean processDrop(Event event) {
        Point point = BWTUtil.translateToParent(this.getFrame(), this, event.x, event.y);
        Component component = this.locateComponent(this.getFrame(), point.x, point.y);
        if (component == this || !(component instanceof JCOutlinerComponent)) {
            return false;
        }
        point = BWTUtil.translateFromParent(this.getFrame(), component, point.x, point.y);
        event.x = point.x;
        event.y = point.y;
        return ((JCOutlinerComponent)component).drop(event);
    }

    public boolean drop(Event event) {
        int n;
        if (this.drag_drop == 0) {
            return false;
        }
        if (event.target == this && drag_node == null) {
            return false;
        }
        if (drag_node == drop_node || drop_node == null || drag_node == this.root) {
            if (drag_node != this.root && drop_node != null) {
                JCOutlinerComponent.drop_node.selected = true;
                this.drawNode(drop_node, true);
            }
            this.setCursor(0);
            drop_node = null;
            drag_node = null;
            return true;
        }
        JCOutlinerFolderNode jCOutlinerFolderNode = drop_node instanceof JCOutlinerFolderNode ? (JCOutlinerFolderNode)drop_node : drop_node.getParent();
        int n2 = n = drop_node == jCOutlinerFolderNode ? 0 : jCOutlinerFolderNode.getChildren().indexOf(drop_node) + 1;
        if (event.target != this) {
            drag_node = (JCOutlinerNode)drag_node.clone();
        }
        jCOutlinerFolderNode.addNode(drag_node, n);
        this.folderChanged(jCOutlinerFolderNode);
        JCOutlinerComponent.drop_node.selected = false;
        this.selected_node = null;
        this.selectNode(drag_node);
        this.setCursor(0);
        this.repaint();
        drop_node = null;
        drag_node = null;
        return true;
    }

    JCOutlinerNodeStyle getStyle(JCOutlinerNode jCOutlinerNode) {
        if (jCOutlinerNode != null && jCOutlinerNode.style != null) {
            return jCOutlinerNode.style;
        }
        return this.default_style;
    }

    public Rectangle getBounds(JCOutlinerNode jCOutlinerNode, Rectangle rectangle) {
        this.getDrawingArea(this.draw_rect);
        int n = this.draw_rect.x + jCOutlinerNode.indent * this.node_indent - this.horiz_origin + this.getColumnLeftMargin(0);
        int n2 = this.draw_rect.y + jCOutlinerNode.row * this.full_node_height - this.vert_origin;
        JCOutlinerNodeStyle jCOutlinerNodeStyle = this.getStyle(jCOutlinerNode);
        Font font = jCOutlinerNodeStyle.font != null ? jCOutlinerNodeStyle.font : this.getFont();
        int n3 = BWTUtil.getWidth(jCOutlinerNode.label, this, font) + 2 * this.highlight;
        Image image = this.getIcon(jCOutlinerNode);
        if (!this.root_visible && this.root_shortcut) {
            n += this.node_indent / 2;
        }
        if (image != null) {
            n3 += image.getWidth(null) + this.getStyle((JCOutlinerNode)jCOutlinerNode).icon_spacing;
        }
        if (rectangle != null) {
            rectangle.reshape(n, n2, n3, this.full_node_height);
            return null;
        }
        return new Rectangle(n, n2, n3, this.full_node_height);
    }

    protected Image getIcon(JCOutlinerNode jCOutlinerNode) {
        JCOutlinerNodeStyle jCOutlinerNodeStyle = this.getStyle(jCOutlinerNode);
        if (jCOutlinerNode instanceof JCOutlinerFolderNode) {
            int n = ((JCOutlinerFolderNode)jCOutlinerNode).state;
            if (n == 1) {
                if (jCOutlinerNode.selected && jCOutlinerNodeStyle.folder_closed_selected != null) {
                    return jCOutlinerNodeStyle.folder_closed_selected;
                }
                return jCOutlinerNodeStyle.folder_closed;
            }
            if (jCOutlinerNode.selected && jCOutlinerNodeStyle.folder_open_selected != null) {
                return jCOutlinerNodeStyle.folder_open_selected;
            }
            return jCOutlinerNodeStyle.folder_open;
        }
        if (jCOutlinerNode.selected && jCOutlinerNodeStyle.item_selected != null) {
            return jCOutlinerNodeStyle.item_selected;
        }
        return jCOutlinerNodeStyle.item;
    }

    protected boolean shouldBeDrawn(JCOutlinerNode jCOutlinerNode) {
        if (jCOutlinerNode == this.root) {
            return this.root_visible;
        }
        if (jCOutlinerNode == null || jCOutlinerNode.parent == null) {
            return false;
        }
        int n = jCOutlinerNode.parent.state;
        if (n == 5) {
            if (jCOutlinerNode.parent != this.root) {
                return this.shouldBeDrawn(jCOutlinerNode.parent);
            }
            return true;
        }
        if (n == 1 || n == 2) {
            return false;
        }
        if (n == 3 && !(jCOutlinerNode instanceof JCOutlinerFolderNode)) {
            return false;
        }
        if (n == 4 && jCOutlinerNode instanceof JCOutlinerFolderNode) {
            return false;
        }
        if (jCOutlinerNode.parent != this.root) {
            return this.shouldBeDrawn(jCOutlinerNode.parent);
        }
        return true;
    }

    protected boolean isVisible(JCOutlinerNode jCOutlinerNode) {
        this.getDrawingArea(this.draw_rect);
        int n = this.draw_rect.y + jCOutlinerNode.row * this.full_node_height - this.vert_origin;
        return n + this.full_node_height > this.draw_rect.y && n < this.draw_rect.y + this.draw_rect.height;
    }

    protected boolean drawNode(JCOutlinerNode jCOutlinerNode, boolean bl) {
        if (this.getPeer() == null || !this.isShowing() || !this.shouldBeDrawn(jCOutlinerNode)) {
            return false;
        }
        this.getDrawingArea(this.draw_rect);
        Graphics graphics = this.getGraphics();
        Graphics graphics2 = this.getDoubleBufferGraphics();
        graphics2.setClip(this.draw_rect);
        boolean bl2 = this.drawNode(jCOutlinerNode, graphics2, bl);
        graphics.drawImage(this.getDoubleBufferImage(), 0, 0, null);
        graphics.dispose();
        return bl2;
    }

    protected boolean drawNode(JCOutlinerNode jCOutlinerNode, Graphics graphics, boolean bl) {
        Color color;
        if (jCOutlinerNode == null) {
            return false;
        }
        if (jCOutlinerNode == this.root && !this.root_visible) {
            return false;
        }
        if (!this.isVisible(jCOutlinerNode)) {
            return false;
        }
        this.getBounds(jCOutlinerNode, this.draw_rect);
        if (this.getPaintRect() != null && !this.draw_rect.intersects(this.getPaintRect())) {
            return true;
        }
        this.getDrawingAreaWidth();
        JCOutlinerNodeStyle jCOutlinerNodeStyle = this.getStyle(jCOutlinerNode);
        Font font = jCOutlinerNodeStyle.font != null ? jCOutlinerNodeStyle.font : this.getFont();
        int n = BWTUtil.getWidth(jCOutlinerNode.label, this, font) + 2 * this.highlight;
        Image image = this.getIcon(jCOutlinerNode);
        if (image != null) {
            n += image.getWidth(null) + jCOutlinerNodeStyle.icon_spacing;
        }
        if (this.isEnabled() && jCOutlinerNode == this.focus_node && !jCOutlinerNode.selected) {
            graphics.setColor(Color.yellow);
            BWTUtil.drawDashedRect(graphics, this.draw_rect.x, this.draw_rect.y, n - 1, this.draw_rect.height - 1);
        }
        if (jCOutlinerNode.selected) {
            color = jCOutlinerNodeStyle.background_selected;
            graphics.setColor(color != null ? color : this.getForeground());
            graphics.fillRect(this.draw_rect.x, this.draw_rect.y, n, this.draw_rect.height);
            if (jCOutlinerNode == this.focus_node) {
                graphics.setColor(Color.yellow);
                BWTUtil.drawDashedRect(graphics, this.draw_rect.x, this.draw_rect.y, n - 1, this.draw_rect.height - 1);
            }
            graphics.setColor((color = jCOutlinerNodeStyle.foreground_selected) != null ? color : this.getBackground());
        } else if (bl) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(this.draw_rect.x, this.draw_rect.y, n, this.draw_rect.height);
            color = jCOutlinerNodeStyle.foreground;
            graphics.setColor(color != null ? color : this.getForeground());
        } else {
            color = jCOutlinerNodeStyle.foreground;
            graphics.setColor(color != null ? color : this.getForeground());
        }
        graphics.setFont(jCOutlinerNodeStyle.font != null ? jCOutlinerNodeStyle.font : this.getFont());
        this.draw_rect.translate(this.highlight, this.highlight);
        this.draw_rect.width -= 2 * this.highlight;
        this.draw_rect.height -= 2 * this.highlight;
        if (image != null) {
            int n2 = this.draw_rect.y + (this.draw_rect.height - image.getHeight(null)) / 2;
            graphics.drawImage(image, this.draw_rect.x, n2, this);
            this.draw_rect.x += image.getWidth(null) + jCOutlinerNodeStyle.icon_spacing;
        }
        this.data.draw(graphics, jCOutlinerNode.label, this.draw_rect);
        return true;
    }

    private boolean isLastEntry(JCOutlinerFolderNode jCOutlinerFolderNode, int n) {
        if (jCOutlinerFolderNode.state == 5) {
            return n == jCOutlinerFolderNode.children.size() - 1;
        }
        int n2 = n + 1;
        while (n2 < jCOutlinerFolderNode.children.size()) {
            JCOutlinerNode jCOutlinerNode = (JCOutlinerNode)jCOutlinerFolderNode.children.elementAt(n2);
            if (jCOutlinerNode instanceof JCOutlinerFolderNode && jCOutlinerFolderNode.state == 3) {
                return false;
            }
            if (!(jCOutlinerNode instanceof JCOutlinerFolderNode) && jCOutlinerFolderNode.state == 4) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected int drawNode(JCOutlinerNode jCOutlinerNode, int n, int n2, Graphics graphics) {
        if (jCOutlinerNode == null) {
            return 0;
        }
        int n3 = 1;
        jCOutlinerNode.indent = n;
        jCOutlinerNode.row = n2;
        if (this.drawNode(jCOutlinerNode, graphics, false)) {
            this.visible_nodes.addElement(jCOutlinerNode);
        }
        this.getBounds(jCOutlinerNode, this.draw_rect);
        if (this.draw_rect.y <= this.bottom_y && jCOutlinerNode instanceof JCOutlinerFolderNode) {
            JCOutlinerFolderNode jCOutlinerFolderNode = (JCOutlinerFolderNode)jCOutlinerNode;
            int n4 = jCOutlinerFolderNode.state;
            if (jCOutlinerFolderNode.children == null || n4 == 1 || n4 == 2) {
                return n3;
            }
            int n5 = this.draw_rect.y + this.full_node_height;
            int n6 = this.full_node_height / 2;
            int n7 = this.draw_rect.x;
            int n8 = 0;
            while (n8 < jCOutlinerFolderNode.children.size() && n5 <= this.bottom_y) {
                JCOutlinerNode jCOutlinerNode2 = (JCOutlinerNode)jCOutlinerFolderNode.children.elementAt(n8);
                if (this.shouldBeDrawn(jCOutlinerNode2)) {
                    int n9 = this.drawNode(jCOutlinerNode2, n + 1, n2 + n3, graphics);
                    if (jCOutlinerNode != this.root || this.root_shortcut || jCOutlinerNode == this.root && this.root_visible) {
                        int n10 = n7 + this.node_indent / 2;
                        int n11 = n5 + this.full_node_height / 2;
                        JCOutlinerNodeStyle jCOutlinerNodeStyle = this.getStyle(jCOutlinerNode2);
                        graphics.setColor(jCOutlinerNodeStyle.line_color != null ? jCOutlinerNodeStyle.line_color : this.getForeground());
                        graphics.drawLine(n10, n11, n10 + this.node_indent / 2 - 1, n11);
                        if (this.isLastEntry(jCOutlinerFolderNode, n8)) {
                            graphics.drawLine(n10, n5, n10, n5 + n6);
                        } else {
                            graphics.drawLine(n10, n5, n10, n5 + n9 * this.full_node_height + n6);
                        }
                        if (this.isVisible(jCOutlinerNode2)) {
                            this.drawShortcut(jCOutlinerNode2, graphics, n10, n11);
                        }
                    }
                    n3 += n9;
                    n5 += n9 * this.full_node_height;
                }
                ++n8;
            }
        }
        return n3;
    }

    protected void drawShortcut(JCOutlinerNode jCOutlinerNode, Graphics graphics, int n, int n2) {
        if (!(jCOutlinerNode instanceof JCOutlinerFolderNode)) {
            return;
        }
        JCOutlinerFolderNode jCOutlinerFolderNode = (JCOutlinerFolderNode)jCOutlinerNode;
        JCOutlinerNodeStyle jCOutlinerNodeStyle = this.getStyle(jCOutlinerNode);
        if (jCOutlinerNodeStyle.shortcut) {
            Image image = jCOutlinerFolderNode.state == 1 ? this.shortcut_open_icon : this.shortcut_close_icon;
            graphics.drawImage(image, n - 4, n2 - 4, this);
            jCOutlinerFolderNode.shortcut_x = n;
            jCOutlinerFolderNode.shortcut_y = n2;
            return;
        }
        jCOutlinerFolderNode.shortcut_x = -999;
    }

    protected int countRows(JCOutlinerNode jCOutlinerNode) {
        int n;
        if (jCOutlinerNode == null || jCOutlinerNode != this.root && jCOutlinerNode.parent == null) {
            return 0;
        }
        int n2 = n = jCOutlinerNode != this.root ? jCOutlinerNode.parent.state : jCOutlinerNode.getState();
        if (n == 3 && !(jCOutlinerNode instanceof JCOutlinerFolderNode)) {
            return 0;
        }
        if (n == 4 && jCOutlinerNode != this.root && jCOutlinerNode instanceof JCOutlinerFolderNode) {
            return 0;
        }
        if (!(jCOutlinerNode instanceof JCOutlinerFolderNode)) {
            return 1;
        }
        n = jCOutlinerNode.getState();
        JCVector jCVector = jCOutlinerNode.getChildren();
        if (n == 1 || n == 2 || jCVector == null) {
            return 1;
        }
        int n3 = 1;
        int n4 = 0;
        int n5 = jCVector.size();
        while (n4 < n5) {
            n3 += this.countRows((JCOutlinerNode)jCVector.elementAt(n4));
            ++n4;
        }
        return n3;
    }

    protected int countChildren(JCOutlinerNode jCOutlinerNode) {
        if (jCOutlinerNode == null || jCOutlinerNode != this.root && jCOutlinerNode.parent == null) {
            return 0;
        }
        if (!(jCOutlinerNode instanceof JCOutlinerFolderNode)) {
            return 1;
        }
        JCVector jCVector = jCOutlinerNode.getChildren();
        if (jCVector == null) {
            return 1;
        }
        int n = 1;
        int n2 = 0;
        int n3 = jCVector.size();
        while (n2 < n3) {
            n += this.countChildren((JCOutlinerNode)jCVector.elementAt(n2));
            ++n2;
        }
        return n;
    }

    protected int countPreviousRows(JCOutlinerNode jCOutlinerNode) {
        return this.countRows(this.root, jCOutlinerNode);
    }

    protected int countRows(JCOutlinerNode jCOutlinerNode, JCOutlinerNode jCOutlinerNode2) {
        int n = jCOutlinerNode.sequence;
        int n2 = 0;
        int n3 = this.node_list.size();
        while (n < n3) {
            JCOutlinerNode jCOutlinerNode3 = (JCOutlinerNode)this.node_list.elementAt(n);
            if (jCOutlinerNode3 == jCOutlinerNode2) {
                return n2;
            }
            if (this.shouldBeDrawn(jCOutlinerNode3)) {
                ++n2;
            }
            ++n;
        }
        return 0;
    }

    protected int countAllNodes(JCOutlinerNode jCOutlinerNode, JCVector jCVector) {
        if (jCOutlinerNode == null) {
            return 0;
        }
        if (jCVector != null) {
            jCOutlinerNode.sequence = jCVector.size();
            jCOutlinerNode.outliner = this;
            jCVector.addElement(jCOutlinerNode);
        }
        if (!(jCOutlinerNode instanceof JCOutlinerFolderNode)) {
            return 1;
        }
        int n = 1;
        JCVector jCVector2 = jCOutlinerNode.getChildren();
        if (jCVector2 != null) {
            int n2 = 0;
            int n3 = jCVector2.size();
            while (n2 < n3) {
                n += this.countAllNodes((JCOutlinerNode)jCVector2.elementAt(n2), jCVector);
                ++n2;
            }
        }
        return n;
    }

    protected JCOutlinerNode findNode(JCOutlinerNode jCOutlinerNode, int n) {
        if (jCOutlinerNode == null || jCOutlinerNode.row == n) {
            return jCOutlinerNode;
        }
        if (!(jCOutlinerNode instanceof JCOutlinerFolderNode)) {
            return null;
        }
        JCOutlinerFolderNode jCOutlinerFolderNode = (JCOutlinerFolderNode)jCOutlinerNode;
        if (jCOutlinerFolderNode.children == null || jCOutlinerFolderNode.state == 1 || jCOutlinerFolderNode.state == 2) {
            return null;
        }
        int n2 = 0;
        int n3 = jCOutlinerFolderNode.children.size();
        while (n2 < n3) {
            JCOutlinerNode jCOutlinerNode2;
            JCOutlinerNode jCOutlinerNode3 = (JCOutlinerNode)jCOutlinerFolderNode.children.elementAt(n2);
            if (this.shouldBeDrawn(jCOutlinerNode3) && (jCOutlinerNode2 = this.findNode(jCOutlinerNode3, n)) != null) {
                return jCOutlinerNode2;
            }
            ++n2;
        }
        return null;
    }

    public boolean compare(Object object, Object object2) {
        JCOutlinerNode jCOutlinerNode = (JCOutlinerNode)object;
        object = jCOutlinerNode.label;
        if (object instanceof Vector) {
            object = this.sort_column < ((Vector)object).size() ? ((Vector)object).elementAt(this.sort_column) : null;
        } else if (this.sort_column > 0) {
            object = null;
        }
        JCOutlinerNode jCOutlinerNode2 = (JCOutlinerNode)object2;
        object2 = jCOutlinerNode2.label;
        if (object2 instanceof Vector) {
            object2 = this.sort_column < ((Vector)object2).size() ? ((Vector)object2).elementAt(this.sort_column) : null;
        } else if (this.sort_column > 0) {
            object2 = null;
        }
        if (this.sort_direction == 0) {
            return JCqsort.gt(object, object2, this.sort_method);
        }
        return JCqsort.lt(object, object2, this.sort_method);
    }

    public void sort(int n, JCSortInterface jCSortInterface, int n2) {
        if (!(this.root instanceof JCOutlinerFolderNode)) {
            return;
        }
        this.sort_column = n;
        this.sort_direction = n2;
        this.sort_method = jCSortInterface;
        this.sort((JCOutlinerFolderNode)this.root);
        this.processRootNode();
        this.repaint();
        this.requestFocus();
    }

    void sort(JCOutlinerFolderNode jCOutlinerFolderNode) {
        if (jCOutlinerFolderNode == null || jCOutlinerFolderNode != this.root && jCOutlinerFolderNode.parent == null || jCOutlinerFolderNode.children == null || jCOutlinerFolderNode.state == 1) {
            return;
        }
        new JCqsort(jCOutlinerFolderNode.children, this).sort(0, this.sort_direction);
        int n = 0;
        int n2 = jCOutlinerFolderNode.children.size();
        while (n < n2) {
            Object e = jCOutlinerFolderNode.children.elementAt(n);
            if (e instanceof JCOutlinerFolderNode) {
                this.sort((JCOutlinerFolderNode)e);
            }
            ++n;
        }
    }

    protected int calcWidth(JCOutlinerNode jCOutlinerNode, int n) {
        Object object = jCOutlinerNode.label;
        if (object == null) {
            return 0;
        }
        if (n > 0 && (!(object instanceof Vector) || BWTUtil.is_jcstring(object))) {
            return 0;
        }
        if (object instanceof Vector && !BWTUtil.is_jcstring(object)) {
            if (n >= ((Vector)object).size()) {
                return 0;
            }
            object = ((Vector)object).elementAt(n);
        }
        JCOutlinerNodeStyle jCOutlinerNodeStyle = this.getStyle(jCOutlinerNode);
        Font font = jCOutlinerNodeStyle.font != null ? jCOutlinerNodeStyle.font : this.getFont();
        int n2 = BWTUtil.getWidth(object, this, font);
        if (n > 0) {
            return n2;
        }
        Image image = this.getIcon(jCOutlinerNode);
        if (image != null) {
            n2 += image.getWidth(null) + this.getStyle((JCOutlinerNode)jCOutlinerNode).icon_spacing;
        }
        return n2 + jCOutlinerNode.getLevel() * this.node_indent;
    }

    public int calcWidth(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.node_list.size();
        while (n3 < n4) {
            JCOutlinerNode jCOutlinerNode = (JCOutlinerNode)this.node_list.elementAt(n3);
            n2 = Math.max(n2, this.calcWidth(jCOutlinerNode, n));
            ++n3;
        }
        return n2 + this.getColumnLeftMargin(n) + this.getColumnRightMargin(n);
    }

    public int[] getColumnWidths() {
        return this.data.getColumnWidths();
    }

    public void setColumnWidths(int[] nArray) {
        this.data.setColumnWidths(nArray);
        this.updateParent();
        this.repaint();
    }

    public int getColumnWidth(int n) {
        return this.data.getColumnWidth(n);
    }

    public void setColumnWidth(int n, int n2) {
        this.data.setColumnWidth(n, n2);
        if (this.getHeader() != null) {
            this.getHeader().setColumnWidth(n, n2);
        }
        this.updateParent();
        this.repaint();
    }

    public int getNumColumns() {
        return this.data.num_columns;
    }

    public void setNumColumns(int n) {
        this.data.setNumColumns(n);
        this.updateParent();
        this.repaint();
    }

    public int[] getColumnAlignments() {
        return this.data.getColumnAlignments();
    }

    public int getColumnAlignment(int n) {
        return this.data.getColumnAlignment(n);
    }

    public void setColumnAlignment(int n, int n2) {
        if (n != 0) {
            this.data.setColumnAlignment(n, n2);
        }
        this.repaint();
    }

    public void setColumnAlignments(int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            nArray[0] = 3;
        }
        this.data.setColumnAlignments(nArray);
        this.repaint();
    }

    public int getColumnPosition(int n) {
        return this.data.getColumnPosition(n) + this.shadow + this.highlight + this.insets.left - this.horiz_origin;
    }

    public int getColumnLeftMargin(int n) {
        return this.data.getColumnLeftMargin(n);
    }

    public void setColumnLeftMargin(int n, int n2) {
        this.data.setColumnLeftMargin(n, n2);
        this.calcColumnWidths();
        this.repaint();
    }

    public int getColumnRightMargin(int n) {
        return this.data.getColumnRightMargin(n);
    }

    public void setColumnRightMargin(int n, int n2) {
        this.data.setColumnRightMargin(n, n2);
        this.calcColumnWidths();
        this.repaint();
    }

    public JCMultiColumnData getMultiColumnData() {
        return this.data;
    }

    public int getHorizOrigin() {
        return this.horiz_origin;
    }

    public void setHorizOrigin(int n) {
        this.horiz_origin = n;
    }

    public int getVertOrigin() {
        return this.vert_origin;
    }

    public void setVertOrigin(int n) {
        this.vert_origin = n;
    }

    static {
        item_icon = new String[]{"                ", "   .......      ", "   .XXXXXX.     ", "   .XXXXXXX.    ", "   .X.....XX.   ", "   .XXXXXXXX.   ", "   .X......X.   ", "   .XXXXXXXX.   ", "   .X......X.   ", "   .XXXXXXXX.   ", "   .X......X.   ", "   .XXXXXXXX.   ", "   .X......X.   ", "   .XXXXXXXX.   ", "   ..........   ", "                "};
        folder_open_icon = new String[]{"  ......        ", " .XXXXXX.       ", " .XXXXXX.       ", ".XXXXXXXX..     ", ".XXXXXXXXXX.    ", ".XXXXXXXXXX.    ", ".XXX........... ", ".XXX.ooooooooo. ", ".XX.oooooooooo. ", ".XX.ooooooooo.  ", ".X.oooooooooo.  ", ".X.ooooooooo.   ", "..oooooooooo.   ", " ...........    ", "                ", "                "};
        folder_closed_icon = new String[]{"  ........      ", " .XXXXXXXX.     ", " .XXXXXXXX.     ", "............... ", ".XXXXXXXXXXXXXX.", ".XXXXXXXXXXXXXX.", ".XXXXXXXXXXXXXX.", ".XXXXXXXXXXXXXX.", ".XXXXXXXXXXXXXX.", ".XXXXXXXXXXXXXX.", ".XXXXXXXXXXXXXX.", ".XXXXXXXXXXXXXX.", ".XXXXXXXXXXXXXX.", " ...............", "                ", "                "};
        shortcut_open_icon_string = new String[]{".........", ".       .", ".   .   .", ".   .   .", ". ..... .", ".   .   .", ".   .   .", ".       .", "........."};
        shortcut_close_icon_string = new String[]{".........", ".       .", ".       .", ".       .", ". ..... .", ".       .", ".       .", ".       .", "........."};
    }
}

